function pageLoad() {
    var nodeList, index;

    // Get a NodeList of all of the images on the page; will include
    // both the images we want to update and those we don't
    nodeList = document.body.getElementsByTagName('img');

    // Kick-start the process
    index = 0;
    backgroundLoader();

    // Our background loader
    function backgroundLoader() {
        var img, src;

        // Note we check at the beginning of the function rather than
        // the end when we're scheduling. That's because NodeLists are
        // *live*, so they can change between invocations of our function.
        // So avoid going past what is _now_ the end of the list.
        // And yes, this means that if you remove images from
        // the middle of the document while the load process is running,
        // we may end up missing some. Don't do that, or account for it.
        if (index >= nodeList.length) {
            // we're done
            return;
        }

        // Get this image
        img = nodeList[index];

        // Process it
        src = img.getAttribute("data-src");
        if (src) {
            // It's one of our special ones
            img.src = src;
            img.removeAttribute("data-src");
        }

        // Schedule the next one
        ++index;
        window.setTimeout(backgroundLoader, 200);
    }
}

function addLoadEvent(func) {
  var oldonload = window.onload;
  if (typeof window.onload != 'function') {
    window.onload = func;
  } else {
    window.onload = function() {
      if (oldonload) {
        oldonload();
      }
      func();
    }
  }
}
addLoadEvent(pageLoad);